function mtx = ExportBinOxford(Bin,expt,intervals)

    % Checking if the Reference Deconvolution limits have been set
    hMainFigure = findobj('Type','figure','Tag','MainFigure');
    if ~isempty(hMainFigure)
        NmrData = guidata(hMainFigure(1));
    end

    if expt == 1 % Exporting to .txt
        row1 = "A 1.0 #regions in PPM";
        row2 = "# low field   high field  bias        slope";
        
        HF_B = "0." + string(zeros(size(Bin, 1),1)) + " ";
        region = "# for region " + string(1:size(Bin, 1)); region = region';
        str_bin1 = string(flip(round(Bin(:,1),2))) + " ";
        str_bin2 = " " + string(flip(round(Bin(:,2),2))) + " ";
    
        labels = [row1;row2];
        limits = [str_bin2 + str_bin1 + HF_B + HF_B + region];
    
        limits = [labels;limits];

    elseif expt == 2 % Exporting to Excel
        try
            ID = string(["ID";string(1:size(NmrData.Classes.Labels.LabelArray,1))']);
            CLASS = string(["CLASS";string(NmrData.Classes.Labels.LabelArray)]);
        catch ME
            ID = string(["ID";string(1:size(Bin,1))']);
            CLASS = string(["CLASS";string(1:size(Bin,1))']);
        end

        limits = "[" + round(intervals(:,1),2) + ".." + round(intervals(:,2),2) + "]";
        lmt = [limits';Bin];

        mtx = [ID CLASS lmt];
    end
end